**************************************************************************************************
*******************"ADOPTION OF GPT" PAPER - EVENT STUDIES****************************************
*************************DATE: OCT 2023 **********************************************************
************************ AUTHOR: KIM NGUYEN AND JONATHAN HAMBUR **********************************
**************************************************************************************************

//LOAD DATA
use "Final_data.dta", clear

//ROA EVENT STUDIES

//Aggregate, Early vs Late adopters 

foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa  {
		local labels : variable label `var'
 
		putexcel set "Graphs-ROA.xls", sheet("Aggregate") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2009  `samp', leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		putexcel clear
		putexcel set "Graphs-ROA.xls", sheet("Early adopters") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2009  `samp' & lateadopters!=1 , leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Late adopters") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
	}

}

//Split by Board characteristics

*** Split by Board GPT
foreach smple in _nonIT {
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa {
		local labels : variable label `var'
 
		putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Board GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==1  `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Board No GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==0 `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
}
}


*** Split by gender
foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa {
		local labels : variable label `var'
 
		putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Board Female") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & female_pcbi==1  `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Board No Female") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & female_pcbi==0 `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
}
}



***** Hiring
foreach smple in _nonIT {
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}

		*** Hiring splits 
	
	foreach var in tech_hire_i   {
				local labels : variable label `var'
						putexcel clear

		putexcel set "Graphs-Hiring.xls", sheet("Board GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 `samp' & lateadopters!=2 & gentech_pcbi==1, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2) noline
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-Hiring.xls", sheet("Board No GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 `samp' & lateadopters!=2 & gentech_pcbi==0, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2) noline
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
	}
}


****** Appendix charts


*** Split by Board GPT - opex and revenue Appendix D

foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in opex_sa {
		local labels : variable label `var'
 
		putexcel clear

		putexcel set "Graphs-OPEX.xls", sheet("Board GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==1  `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-OPEX.xls", sheet("Board No GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==0 `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
}
}

foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in revenue_sa {
		local labels : variable label `var'
 
		putexcel clear

		putexcel set "Graphs-REV.xls", sheet("Board GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==1  `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-REV.xls", sheet("Board No GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==0 `samp'  & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
}
}



*** Accumulated lags and leads

preserve
drop if timetogentech_i<-4
*** No split
foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa {
		local labels : variable label `var'
 
		putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Early accumul") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2009 `samp' & lateadopters!=1 , leads(2) lags(1)  timevar(timetogentech_i) accum method(fe, cluster(id))  level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

putexcel set "Graphs-ROA.xls", sheet("Late accumul") modify		
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 `samp' & lateadopters!=2,  leads(2) lags(1)  timevar(timetogentech_i) accum method(fe, cluster(id))  level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
}
}

*** Split by Board GPT
foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa {
		local labels : variable label `var'
 
		putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Late GPT  accl") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==1  `samp' & lateadopters!=2, leads(2) lags(1)  timevar(timetogentech_i) accum method(fe, cluster(id))  level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

				putexcel set "Graphs-ROA.xls", sheet("Late no GPT  accl") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & gentech_pcbi==0 `samp' & lateadopters!=2,  leads(2) lags(1)  timevar(timetogentech_i) accum method(fe, cluster(id)) level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)

*** Split by Gender
		putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Late Fem  accl") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & female_pcbi==1  `samp' & lateadopters!=2, leads(2) lags(1)  timevar(timetogentech_i) accum method(fe, cluster(id)) level(90) baseline(-2) 
				matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

						putexcel set "Graphs-ROA.xls", sheet("Late no Fem  accl") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014 & female_pcbi==0 `samp' & lateadopters!=2,  leads(2) lags(1)  timevar(timetogentech_i) accum method(fe, cluster(id))  level(90) baseline(-2) 
				matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
}
}

restore




*** Split by size
** size indicators
egen gics_y = group(gics_sector fy)
foreach var in logassets logrevenue {
    egen q_yi_`var' = xtile(`var'), by(gics_y) n(5)
	egen med_yi_`var' = median(`var'), by(gics_y) 
	g abovemedian_yi_`var' = (`var'>med_yi_`var')
	g top2q_yi_`var' = (q_yi_`var'>3)
	replace top2q_yi_`var'=. if q_yi_`var'==. 
}


foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa {
		local labels : variable label `var'
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Late large") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & top2q_yi_logassets==1 & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
			matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Late small") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & top2q_yi_logassets==0 & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
			matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		
				putexcel clear

				putexcel set "Graphs-ROA.xls", sheet("Late large fem ") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & top2q_yi_logassets==1 & lateadopters!=2 & female_pcbi==1 , leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
			matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		
	
			putexcel clear

				putexcel set "Graphs-ROA.xls", sheet("Late large nofem ") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & top2q_yi_logassets==1 & lateadopters!=2 & female_pcbi==0 , leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
			matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)		
		
				putexcel clear

				
		putexcel set "Graphs-ROA.xls", sheet("Late small fem ") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & top2q_yi_logassets==0 & lateadopters!=2 & female_pcbi==1 , leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
			matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		
				putexcel clear

	
				putexcel set "Graphs-ROA.xls", sheet("Late small nofem ") modify

		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & top2q_yi_logassets==0 & lateadopters!=2 & female_pcbi==0 , leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
			matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)		
		

		
		
		
	}

}


*** Alterate profitability measures

foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa_wcap ebit_sa  {
		local labels : variable label `var'
 
		
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Early ad `var'") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2009  `samp' & lateadopters!=1 , leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
				putexcel clear

		putexcel set "Graphs-ROA.xls", sheet("Late ad `var'") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
	}

}


**** Other robustness


*** No mining

foreach smple in _nonITnonmining {
	if "`smple'" == "_nonITnonmining" {
	local samp " & gics_sector != 45 & nonmining == 1" 
	}
	foreach var in roa {
		local labels : variable label `var'
 
		
				putexcel clear

	putexcel set "Graphs-ROA.xls", sheet("Nonmining - Late") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id)) level(90) baseline(-2)
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
	}

}



*** Remove 2021 outcomes

preserve
drop if fy>=2021

foreach smple in _nonIT {
	if "`smple'" == "_all" {
	local samp 
	}
	
	if "`smple'" == "_IT" {
	local samp " & gics_sector == 45"
	}
	
	if "`smple'" == "_nonIT" {
	local samp " & gics_sector != 45"
	}
	foreach var in roa {
		local labels : variable label `var'
 
		putexcel clear

putexcel set "Graphs-ROA.xls", sheet("Late no21") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & lateadopters!=2, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		
				putexcel clear

putexcel set "Graphs-ROA.xls", sheet("Late no21 GPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & lateadopters!=2 & gentech_pcbi==1, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)
		
						putexcel clear

putexcel set "Graphs-ROA.xls", sheet("Late no21 noGPT") modify
		eventdd `var' logasset i.fy##i.gics_sector if fy>=2014  `samp' & lateadopters!=2 & gentech_pcbi==0, leads(4) lags(3)  timevar(timetogentech_i) inrange method(fe, cluster(id))  level(90) baseline(-2) 
		matrix lags = e(leads)
		matrix leads = e(lags)
		putexcel A1=matrix(lags) E1=matrix(leads)		
	}

}

